package w83b.w83bDAO;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;


import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bCitacionBean;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCitacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCitacionesVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bInteresadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMunicipiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bProvinciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bRespAreaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosImpugnacionBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;


public class W83bCitacionesDAO implements W83bICitacionesDAO {
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public List buscarCitaciones(w83b.w83bBeans.W83bCitacionBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		String formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO;;
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
		{
			
			formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA;
		}
		
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bCitacionesVistaBD.NCITACION).append(", ");
		strSql.append(W83bCitacionesVistaBD.NOMBREIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.DATOSSINDICATOS).append(", ");
		strSql.append(W83bCitacionesVistaBD.CIF).append(", ");
		
		strSql.append(W83bCitacionesVistaBD.NCENTRO).append(", TO_CHAR(");
		strSql.append(W83bCitacionesVistaBD.HORACITACIONI).append(",?) AS ").append(W83bCitacionesVistaBD.FECHACITACION).append(", TO_CHAR( ");
		strSql.append(W83bCitacionesVistaBD.HORACITACIONI).append(",?) AS ").append(W83bCitacionesVistaBD.HORACITACIONI).append(", TO_CHAR(");
		strSql.append(W83bCitacionesVistaBD.HORACITACIONF).append(",?) AS ").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ");
		strSql.append(W83bCitacionesVistaBD.MESA).append(", ");
		strSql.append(W83bCitacionesVistaBD.RAZONSOCIAL).append(", ");
		strSql.append(W83bCitacionesVistaBD.DNIIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.numLaudo).append(", ");
		strSql.append(W83bCitacionesVistaBD.NACTA);

		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	
		params.add("HH24:MI");
		params.add("HH24:MI");
		
		strSql.append(" FROM ").append(W83bCitacionesVistaBD.citacionesView);
		strSql.append(" WHERE ").append(" ").append(W83bCitacionesVistaBD.numImpugnacion).append(" > 0");
		List restoSql=((List)this.getBusquedaSql(param,params, formatoFechaCompleta));
		strSql.append((StringBuffer)restoSql.get(0));
		params=(List)restoSql.get(1);
	
		
		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());	
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bCitacionBean.class,param.getUsuarioBean(), null);
		
		return listaActas;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public String contarCitaciones(w83b.w83bBeans.W83bCitacionBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO;;
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
		{
			
			formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA;
		}
		strSql.append("SELECT COUNT(");
		strSql.append(W83bCitacionesVistaBD.NCITACION).append(") ");
				
		strSql.append(" FROM ").append(W83bCitacionesVistaBD.citacionesView);
		
		strSql.append(" WHERE ").append(" ").append(W83bCitacionesVistaBD.numImpugnacion).append(" > 0");
		List restoSql=((List)this.getBusquedaSql(param,params, formatoFechaCompleta));
		strSql.append((StringBuffer)restoSql.get(0));
		params=(List)restoSql.get(1);
		
		List listaCitaciones = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaCitaciones.get(0).toString();	
	}
	
	private List getBusquedaSql(W83bCitacionBean param, List parametros,String formatoFechaCompleta)
	{
		List resul=new ArrayList();
		List params=parametros;
		StringBuffer strSql=new StringBuffer(W83bClsConstantes.CUARENTA);
		//NMERO DE Impugnacion
		if(StringUtils.isNotEmpty(param.getNumImpugnacionTerritorioDesde())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.codTerritorioImpugnacion).append(" >= ?");
			params.add(new Integer(param.getNumImpugnacionTerritorioDesde()));
		}		
		if(StringUtils.isNotEmpty(param.getNumImpugnacionAnyoDesde())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.anyoImpugnacion).append(" >= ?");
			params.add(new Integer(param.getNumImpugnacionAnyoDesde()));
		}	
		if(StringUtils.isNotEmpty(param.getNumImpugnacionTerritorioHasta())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.codTerritorioImpugnacion).append(" <= ?");
			params.add(new Integer(param.getNumImpugnacionTerritorioHasta()));
		}
		if(StringUtils.isNotEmpty(param.getNumImpugnacionAnyoHasta())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.anyoImpugnacion).append(" <= ?");
			params.add(new Integer(param.getNumImpugnacionAnyoHasta()));
		}
		if(StringUtils.isNotEmpty(param.getNumImpugnacionNumeroHasta())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.numImpugnacion).append(" <= ?");
			params.add(new Integer(param.getNumImpugnacionNumeroHasta()));
		}
		if(StringUtils.isNotEmpty(param.getNumImpugnacionNumeroDesde())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.numImpugnacion).append(" >= ?");
			params.add(new Integer(param.getNumImpugnacionNumeroDesde()));
		}		
		
		//fin NMERO DE impugnacion
		
		
	
		//FECHA CITACION
		if(StringUtils.isNotEmpty(param.getFechaCitacionDel())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.HORACITACIONI).append(" >= to_date(?,?)");
			params.add(param.getFechaCitacionDel()+" 00:00:00 ");
			params.add(formatoFechaCompleta);
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaCitacionHasta())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.HORACITACIONI).append(" <= to_date(?,?)");
			params.add(param.getFechaCitacionHasta()+" 23:59:59 ");
			params.add(formatoFechaCompleta);
		}		
		strSql.append(" AND ").append(W83bCitacionesVistaBD.MESA).append(" = ?");
		params.add(param.getMesa());
		//fin FECHA CITACION
		// HORAS
		// HORAS
		if(StringUtils.isNotEmpty(param.getHoraCitacionInicio())){
	
			      
			strSql.append(" AND ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONI).append(", ? )>? ");
			strSql.append(" OR ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONI).append(", ? )=? ");
			strSql.append(" AND TO_CHAR(").append(W83bCitacionesVistaBD.HORACITACIONI).append(", ? )>=? ) ");
			
			strSql.append(" OR ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ? )>? ");
			strSql.append(" OR ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ? )=? ");
			strSql.append(" AND TO_CHAR(").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ? )>=? ))) ");
			
			params.add("HH24");
			params.add(param.getHoraCitacionInicio().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("HH24");
			params.add(param.getHoraCitacionInicio().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("MI");
			params.add(param.getHoraCitacionInicio().substring(W83bClsConstantes.TRES,W83bClsConstantes.CINCO));
			
			params.add("HH24");
			params.add(param.getHoraCitacionInicio().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("HH24");
			params.add(param.getHoraCitacionInicio().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("MI");
			params.add(param.getHoraCitacionInicio().substring(W83bClsConstantes.TRES,W83bClsConstantes.CINCO));
			
		}		
		if(StringUtils.isNotEmpty(param.getHoraCitacionFinal())){
	
			
		
		      
			strSql.append(" AND ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONI).append(", ? )<? ");
			strSql.append(" OR ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONI).append(", ? )=? ");
			strSql.append(" AND TO_CHAR(").append(W83bCitacionesVistaBD.HORACITACIONI).append(", ? )<=? ) ");
			
			strSql.append(" OR ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ? )<? ");
			strSql.append(" OR ( TO_CHAR( ").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ? )=? ");
			strSql.append(" AND TO_CHAR(").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ? )<=? ))) ");
		
			
			params.add("HH24");
			params.add(param.getHoraCitacionFinal().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("HH24");
			params.add(param.getHoraCitacionFinal().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("MI");
			params.add(param.getHoraCitacionFinal().substring(W83bClsConstantes.TRES,W83bClsConstantes.CINCO));
			
			params.add("HH24");
			params.add(param.getHoraCitacionFinal().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("HH24");
			params.add(param.getHoraCitacionFinal().substring(W83bClsConstantes.ZERO,W83bClsConstantes.DOS));
			params.add("MI");
			params.add(param.getHoraCitacionFinal().substring(W83bClsConstantes.TRES,W83bClsConstantes.CINCO));
			
		}		
		
		
		//MESA
		
		if(StringUtils.isNotEmpty(param.getMesa())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.MESA).append(" = ?");
			params.add(param.getMesa());
		}
		//fin MESA
	
		//CENTRO DE TRABAJO
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCifnif())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.CIF).append(" = ?");
			params.add(param.getCentroTrabajo().getCifnif().toUpperCase());
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.NCENTRO).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getNumCentro()));
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getRazonSocial())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.RAZONSOCIAL).append(" LIKE ?");
			params.add("%"+param.getCentroTrabajo().getRazonSocial().toUpperCase()+"%");
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodMunicipio())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.codMunicipio).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getCodMunicipio()));
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodTerritorio())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.codProvincia).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getCodTerritorio()));
		}
		//fin CENTRO DE TRABAJO
		//dni impug
		if(StringUtils.isNotEmpty(param.getDniImpug())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.DNIIMPUG).append(" LIKE  ?");
			params.add("%"+param.getDniImpug()+"%");
		} 
		
		//dni impug
		if(StringUtils.isNotEmpty(param.getDniImpug())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.DNIIMPUG).append(" LIKE  ?");
			params.add("%"+param.getDniImpug().toUpperCase()+"%");
		} 
		//Nombre impug
		if(StringUtils.isNotEmpty(param.getNombreImpug())){
			strSql.append(" AND ").append(W83bCitacionesVistaBD.NOMBREIMPUG).append(" LIKE  ?");
			params.add("%"+param.getNombreImpug().toUpperCase()+"%");
		} 
		
		//Inicio sindicato
		if(StringUtils.isNotEmpty(param.getSindicato())){
			strSql.append(" AND ? IN (SELECT ").append(W83bCitacionesBD.codSindicatoSindi).append(" FROM ");
			strSql.append(W83bCitacionesBD.sindicatosCitacion).append(" WHERE ");
			strSql.append(W83bCitacionesBD.codTerritorioImpugnacionSindi).append(" = ").append(W83bCitacionesVistaBD.codTerritorioImpugnacion);
			strSql.append(" AND ").append(W83bCitacionesBD.anyoImpugnacionSindi).append(" = ").append(W83bCitacionesVistaBD.anyoImpugnacion);
			strSql.append(" AND ").append(W83bCitacionesBD.numImpugnacionSindi).append(" = ").append(W83bCitacionesVistaBD.numImpugnacion).append(" ) ");
			
			params.add(param.getSindicato());
		} 
		resul.add(strSql);
		resul.add(params);
		return resul;
	}
	public java.util.List cargarCentroTrabajoPreaviso(HashMap mapaResultado) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.cifnif);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.nCentro);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.codMunicipio);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.codTerritorio);
		strSql.append(" , ");
		strSql.append(W83bCentroTrabajoVistaBD.razonsocial);
		
		strSql.append(" FROM ");
		strSql.append(W83bCentroTrabajoVistaBD.nombreVista);
		strSql.append(" INNER JOIN ");
		strSql.append(W83bPreavisosBD.preavisosTable);
		strSql.append(" ON ( ");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro);
		strSql.append(" = ");
		strSql.append(W83bPreavisosBD.id_centro_037);
		strSql.append(" ) ");
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.ano_preaviso_037);
		strSql.append(" = ? AND ");
		strSql.append(W83bPreavisosBD.c_territ_037);
		strSql.append(" = ? AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		strSql.append(" = ? ");
		params.add((String)mapaResultado.get("anio"));
		params.add((String)mapaResultado.get("cterritorio"));
		params.add((String)mapaResultado.get("num"));
		
		
		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		return listaDatosParametros;
	}
	
	
	public List buscarSindicatos(w83b.w83bBeans.W83bCitacionBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ").append(W83bSindicatosBD.codSindicato).append(", ");
		strSql.append(W83bSindicatosBD.descSindicatoCast).append(", ").append(W83bSindicatosBD.descSindicatoEusk).append(", ");
		strSql.append(" FROM ").append(W83bSindicatosBD.sindicatosTable).append(" INNER JOIN ");
		strSql.append(W83bSindicatosImpugnacionBD.sindImpugTable);
		strSql.append(" ON (").append(W83bSindicatosImpugnacionBD.codSind).append(" = ").append(W83bSindicatosBD.codSindicato);
		strSql.append(" WHERE ").append(W83bSindicatosImpugnacionBD.territorio).append(" = ? ");
		strSql.append(" AND ").append(W83bSindicatosImpugnacionBD.anioImpug).append(" = ?");
		strSql.append(" AND ").append(W83bSindicatosImpugnacionBD.numimpug).append(" = ?");
		params.add(param.getTerritorioImpugnacion());
		params.add(param.getAnyoImpugnacion());
		params.add(param.getNumImpugnacion());
		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bSindicatosBean.class,null, param.getIdioma());
		
		return lista;	
	}
	public void anyadirSindicatos(W83bCitacionBean param) throws Exception
	{
		param.setCodsSindicatos("");
		param.setDescSindicatos("");
		param.setDeseSindicatos("");
		param.setDirSindicatos("");
		param.setProvSindicatos("");
		param.setMuniSindicatos("");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto los promotores
		
			HashMap sindicatos=param.getMapaSindicatos();
			Set set=param.getMapaSindicatos().keySet();
			List nums=new ArrayList();
			Iterator it=set.iterator();
			while(it.hasNext())
			{
				String key=(String)it.next();
				String num="";
				if(key.substring(0,3).equals("cod"))
						{
							num=key.substring(3,key.length());
							if(!("AUX").equals(num))
							{
								nums.add(num);
							}
						}
			}
			
			List numOrdenado=nums;
			int temporal;
			for (int i = 0; i < numOrdenado.size() - 1; i++) {
				for (int j = i+1; j < numOrdenado.size(); j++) {
					if (Integer.parseInt((String) numOrdenado.get(j)) < Integer.parseInt((String) numOrdenado.get(i))) {
						temporal = Integer.parseInt((String) numOrdenado.get(j));
						numOrdenado.set(j, numOrdenado.get(i));
						numOrdenado.set(i, temporal+"");
					}
				}
			}
			nums=numOrdenado;
			
			if (nums.size()>0)
			{
				strSql=this.sqlInsertSindicato();
				params= new ArrayList();
				params.add(new Integer(param.getNumImpugnacion()));
				params.add(new Integer(param.getAnyoImpugnacion()));
				params.add(param.getTerritorioImpugnacion().toUpperCase());
	
				for(int i=0;i<nums.size();i++)
				{
					params.add((String)sindicatos.get("cod"+nums.get(i)));
					if (StringUtils.isNotEmpty((String)sindicatos.get("dir"+nums.get(i)))){
						params.add((String)sindicatos.get("dir"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					if (StringUtils.isNotEmpty((String)sindicatos.get("cp"+nums.get(i)))){
						params.add((String)sindicatos.get("cp"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					if (StringUtils.isNotEmpty((String)sindicatos.get("prov"+nums.get(i)))){
						params.add((String)sindicatos.get("prov"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					if (StringUtils.isNotEmpty((String)sindicatos.get("muni"+nums.get(i)))){
						params.add((String)sindicatos.get("muni"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					params.add((String)sindicatos.get("tipo"+nums.get(i)));
									
					W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
					params.remove(params.size()-1);
					params.remove(params.size()-1);
					params.remove(params.size()-1);
					params.remove(params.size()-1);
					params.remove(params.size()-1);
					params.remove(params.size()-1);

				}

			}			
			volcarMapaListas(param);
		
	}
	public void anyadirInteresados(W83bCitacionBean param) throws Exception
	{
		param.setNombreInteresados("");
		param.setDirInteresados("");
		param.setCpInteresados("");
		param.setProvInteresados("");
		param.setMuniInteresados("");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		String strSecuencia = "";
		List params = new ArrayList();
		//meto los promotores
		
			HashMap interesados=param.getMapaInteresados();
			Set set=param.getMapaInteresados().keySet();
			List nums=new ArrayList();
			Iterator it=set.iterator();
			while(it.hasNext())
			{
				String key=(String)it.next();
				String num="";
				if(key.substring(0,3).equals("nom"))
						{
							num=key.substring(3,key.length());
							if(!("AUX").equals(num))
							{
								nums.add(num);
							}
						}
			}
			
			List numOrdenado=nums;
			int temporal;
			for (int i = 0; i < numOrdenado.size() - 1; i++) {
				for (int j = i+1; j < numOrdenado.size(); j++) {
					if (Integer.parseInt((String) numOrdenado.get(j)) < Integer.parseInt((String) numOrdenado.get(i))) {
						temporal = Integer.parseInt((String) numOrdenado.get(j));
						numOrdenado.set(j, numOrdenado.get(i));
						numOrdenado.set(i, temporal+"");
					}
				}
			}
			nums=numOrdenado;
			
			if (nums.size()>0)
			{
				for(int i=0;i<nums.size();i++)
				{
					strSql=this.sqlInsertInteresados();
					params= new ArrayList();//NOPMD
					params.add(new Integer(param.getNumImpugnacion()));//NOPMD
					params.add(new Integer(param.getAnyoImpugnacion()));//NOPMD
					params.add(param.getTerritorioImpugnacion().toUpperCase());
					strSecuencia = "";
					strSecuencia="SELECT "+W83bInteresadosBD.secuenciaInteresados+".NEXTVAL FROM DUAL";
					List psecuencia=new ArrayList();//NOPMD
					List listasecuencia=W83bDataBase.executeSimpleQuery(strSecuencia, psecuencia ,param.getUsuarioBean());
					params.add(new Integer(String.valueOf(listasecuencia.get(0))));//NOPMD
					if (StringUtils.isNotEmpty((String)interesados.get("nom"+nums.get(i)))){
						params.add((String)interesados.get("nom"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					if (StringUtils.isNotEmpty((String)interesados.get("dir"+nums.get(i)))){
						params.add((String)interesados.get("dir"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					if (StringUtils.isNotEmpty((String)interesados.get("cp"+nums.get(i)))){
						params.add((String)interesados.get("cp"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					if (StringUtils.isNotEmpty((String)interesados.get("muni"+nums.get(i)))){
						params.add((String)interesados.get("muni"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
					if (StringUtils.isNotEmpty((String)interesados.get("prov"+nums.get(i)))){
						params.add((String)interesados.get("prov"+nums.get(i)));
					}else{
						params.add(W83bClsConstantes.NULL_STRING);
					}
									
					W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
					params=new ArrayList();//NOPMD

				}

			}			
			volcarMapaListasInteresados(param);
		
	}
	private StringBuffer sqlInsertSindicato() {
		StringBuffer strSql=new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("INSERT INTO ");
		strSql.append(W83bCitacionesBD.sindicatosCitacion);
		strSql.append ("(");
		strSql.append(W83bCitacionesBD.numImpugnacionSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.anyoImpugnacionSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.codTerritorioImpugnacionSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.codSindicatoSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.dirSindicatoSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.cpSindicatoSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.provSindicatoSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.muniSindicatoSindi);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.tipoSindicatoSindi);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?)");
		return strSql;
	}
	
	private StringBuffer sqlInsertInteresados() {
		StringBuffer strSql=new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("INSERT INTO ");
		strSql.append(W83bInteresadosBD.tableInteresados);
		strSql.append ("(");
		strSql.append(W83bInteresadosBD.numimpugInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.anoimpugInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.territInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.idInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.nombreInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.dirInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.cosposInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.munInt);
		strSql.append(",");
		strSql.append(W83bInteresadosBD.provInt);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?)");
		return strSql;
	}

	private void volcarMapaListas(W83bCitacionBean bean)
	{
		//lo que est en el mapa de impugnaciones hay que transformarlo a listas
		bean.setCodsSindicatos("");
		bean.setDescSindicatos("");
		bean.setDeseSindicatos("");
		bean.setDirSindicatos("");
		bean.setProvSindicatos("");
		bean.setMuniSindicatos("");
		bean.setTipoSindicatos("");
		bean.setCpSindicatos("");
		HashMap sindicatos=bean.getMapaSindicatos();
		Set set=bean.getMapaSindicatos().keySet();
		List nums=new ArrayList();
		Iterator it=set.iterator();
		if(bean.getMapaSindicatos()!=null && bean.getMapaSindicatos().size()>0)
		{
			while(it.hasNext())
			{
				String key=(String)it.next();
				String num="";
				if(key.substring(0,3).equals("cod"))
						{
							num=key.substring(3,key.length());
							if(!"AUX".equals(num))
							{
								nums.add(num);
							}
						}
			}
			List numOrdenado=nums;
			int temporal;
			for (int i = 0; i < numOrdenado.size() - 1; i++) {
				for (int j = i+1; j < numOrdenado.size(); j++) {
					if (Integer.parseInt((String) numOrdenado.get(j)) < Integer.parseInt((String) numOrdenado.get(i))) {
						temporal = Integer.parseInt((String) numOrdenado.get(j));
						numOrdenado.set(j, numOrdenado.get(i));
						numOrdenado.set(i, temporal+"");
					}
				}
			}
			nums=numOrdenado;
			if (nums.size()>0)
			{
				boolean primero=true;
				for(int i=0;i<nums.size();i++)
				{
					if(!primero)
					{
						bean.setCodsSindicatos(bean.getCodsSindicatos()+","+(String)sindicatos.get("cod"+nums.get(i)));
						bean.setDescSindicatos(bean.getDescSindicatos()+","+(String)sindicatos.get("desc"+nums.get(i)));
						bean.setDeseSindicatos(bean.getDescSindicatos()+","+(String)sindicatos.get("desc"+nums.get(i)));
						bean.setDirSindicatos(bean.getDirSindicatos()+","+(String)sindicatos.get("dir"+nums.get(i)));
						bean.setProvSindicatos(bean.getProvSindicatos()+","+(String)sindicatos.get("prov"+nums.get(i)));
						bean.setMuniSindicatos(bean.getMuniSindicatos()+","+(String)sindicatos.get("muni"+nums.get(i)));
						bean.setTipoSindicatos(bean.getTipoSindicatos()+","+(String)sindicatos.get("tipo"+nums.get(i)));
						bean.setCpSindicatos(bean.getCpSindicatos()+","+(String)sindicatos.get("cp"+nums.get(i)));
						
					}else{
						bean.setCodsSindicatos(bean.getCodsSindicatos()+(String)sindicatos.get("cod"+nums.get(i)));
						bean.setDescSindicatos(bean.getDescSindicatos()+(String)sindicatos.get("desc"+nums.get(i)));
						bean.setDeseSindicatos(bean.getDescSindicatos()+(String)sindicatos.get("desc"+nums.get(i)));
						bean.setDirSindicatos(bean.getDirSindicatos()+(String)sindicatos.get("dir"+nums.get(i)));
						bean.setProvSindicatos(bean.getProvSindicatos()+(String)sindicatos.get("prov"+nums.get(i)));
						bean.setMuniSindicatos(bean.getMuniSindicatos()+(String)sindicatos.get("muni"+nums.get(i)));
						bean.setTipoSindicatos(bean.getTipoSindicatos()+(String)sindicatos.get("tipo"+nums.get(i)));
						bean.setCpSindicatos(bean.getCpSindicatos()+(String)sindicatos.get("cp"+nums.get(i)));
					}
					primero=false;
				}
					
			}
		}
		//limpiamos el mapa
		bean.setMapaSindicatos(new HashMap());
	}
	private void volcarMapaListasInteresados(W83bCitacionBean bean)
	{
		//lo que est en el mapa de impugnaciones hay que transformarlo a listas
		bean.setNombreInteresados("");
		bean.setDirInteresados("");
		bean.setCpInteresados("");
		bean.setProvInteresados("");
		bean.setMuniInteresados("");
		HashMap interesados=bean.getMapaInteresados();
		Set set=bean.getMapaInteresados().keySet();
		List nums=new ArrayList();
		Iterator it=set.iterator();
		if(bean.getMapaInteresados()!=null && bean.getMapaInteresados().size()>0)
		{
			while(it.hasNext())
			{
				String key=(String)it.next();
				String num="";
				if(key.substring(0,3).equals("nom"))
						{
							num=key.substring(3,key.length());
							if(!"AUX".equals(num))
							{
								nums.add(num);
							}
						}
			}
			List numOrdenado=nums;
			int temporal;
			for (int i = 0; i < numOrdenado.size() - 1; i++) {
				for (int j = i+1; j < numOrdenado.size(); j++) {
					if (Integer.parseInt((String) numOrdenado.get(j)) < Integer.parseInt((String) numOrdenado.get(i))) {
						temporal = Integer.parseInt((String) numOrdenado.get(j));
						numOrdenado.set(j, numOrdenado.get(i));
						numOrdenado.set(i, temporal+"");
					}
				}
			}
			nums=numOrdenado;
			if (nums.size()>0)
			{
				boolean primero=true;
				for(int i=0;i<nums.size();i++)
				{
					if(!primero)
					{
						bean.setNombreInteresados(bean.getDescSindicatos()+","+(String)interesados.get("desc"+nums.get(i)));
						bean.setDirSindicatos(bean.getDirSindicatos()+","+(String)interesados.get("dir"+nums.get(i)));
						bean.setCpInteresados(bean.getProvSindicatos()+","+(String)interesados.get("prov"+nums.get(i)));
						bean.setMuniSindicatos(bean.getMuniSindicatos()+","+(String)interesados.get("muni"+nums.get(i)));
						bean.setProvInteresados(bean.getTipoSindicatos()+","+(String)interesados.get("tipo"+nums.get(i)));
						
					}else{
						bean.setNombreInteresados(bean.getNombreInteresados()+(String)interesados.get("desc"+nums.get(i)));
						bean.setDirSindicatos(bean.getDirSindicatos()+(String)interesados.get("dir"+nums.get(i)));
						bean.setCpInteresados(bean.getCpInteresados()+(String)interesados.get("prov"+nums.get(i)));
						bean.setMuniSindicatos(bean.getMuniSindicatos()+(String)interesados.get("muni"+nums.get(i)));
						bean.setProvInteresados(bean.getProvInteresados()+(String)interesados.get("tipo"+nums.get(i)));
					}
					primero=false;
				}
					
			}
		}
		//limpiamos el mapa
		bean.setMapaInteresados(new HashMap());
	}
	public void anyadirSindicatos(W83bCitacionBean param,String cod, String dir, String prov, String mun, String tipo, String cp) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		String munTemp = mun; 
		String dirTemp = dir; 
		String provTemp = prov; 
		String cpTemp = cp; 
		
		//meto los promotores
		if (StringUtils.isEmpty(munTemp)){
			munTemp=W83bClsConstantes.NULL_STRING;
		}
		if (StringUtils.isEmpty(provTemp)){
			provTemp=W83bClsConstantes.NULL_STRING;
		}
		if (StringUtils.isEmpty(cpTemp)){
			cpTemp=W83bClsConstantes.NULL_STRING;;
		}
		if (StringUtils.isEmpty(dirTemp)){
			dirTemp=W83bClsConstantes.NULL_STRING;;
		}
		
				strSql= this.sqlInsertSindicato();
				params= new ArrayList();
				params.add(new Integer(param.getNumImpugnacion()));
				params.add(new Integer(param.getAnyoImpugnacion()));
				params.add(param.getTerritorioImpugnacion().toUpperCase());
				params.add(cod);
				params.add(dirTemp);
				params.add(cpTemp);
				params.add(provTemp);
				params.add(munTemp);
				params.add(tipo);
				
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				
			
		
	}
	
	public void anyadirInteresados(W83bCitacionBean param,String cod,String nombre, String dir, String prov, String mun, String cp) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		String munTemp = mun; 
		String dirTemp = dir; 
		String provTemp = prov; 
		String cpTemp = cp; 
		String nombreTemp = nombre; 
		
		//meto los promotores
		if (StringUtils.isEmpty(munTemp)){
			munTemp=W83bClsConstantes.NULL_STRING;
		}
		if (StringUtils.isEmpty(dirTemp)){
			dirTemp=W83bClsConstantes.NULL_STRING;
		}
		if (StringUtils.isEmpty(cpTemp)){
			cpTemp=W83bClsConstantes.NULL_STRING;
		}
		if (StringUtils.isEmpty(provTemp)){
			provTemp=W83bClsConstantes.NULL_STRING;
		}
		if (StringUtils.isEmpty(nombreTemp)){
			nombreTemp=W83bClsConstantes.NULL_STRING;
		}
				strSql= this.sqlInsertInteresados();
				params= new ArrayList();
				params.add(new Integer(param.getNumImpugnacion()));
				params.add(new Integer(param.getAnyoImpugnacion()));
				params.add(param.getTerritorioImpugnacion().toUpperCase());
				params.add(cod);
				params.add(nombreTemp);
				params.add(dirTemp);
				params.add(cpTemp);
				params.add(munTemp);
				params.add(provTemp);
				
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				
			
		
	}
	
	public void editarSindicatos(W83bCitacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto los promotores
		param.setCodsSindicatos("");
		param.setDescSindicatos("");
		param.setDeseSindicatos("");
		param.setDirSindicatos("");
		param.setProvSindicatos("");
		param.setMuniSindicatos("");
			HashMap sindicatos=param.getMapaSindicatos();
			Set set=param.getMapaSindicatos().keySet();
			List nums=new ArrayList();
			Iterator it=set.iterator();
			while(it.hasNext())
			{
				String key=(String)it.next();
				String num="";
				if(key.substring(0,3).equals("cod"))
						{
							num=key.substring(3,key.length());
							if(!"AUX".equals(num))
							{
								nums.add(num);
							}
						}
			}
			List numOrdenado=nums;
			int temporal;
			for (int i = 0; i < numOrdenado.size() - 1; i++) {
				for (int j = i+1; j < numOrdenado.size(); j++) {
					if (Integer.parseInt((String) numOrdenado.get(j)) < Integer.parseInt((String) numOrdenado.get(i))) {
						temporal = Integer.parseInt((String) numOrdenado.get(j));
						numOrdenado.set(j, numOrdenado.get(i));
						numOrdenado.set(i, temporal+"");
					}
				}
			}
			nums=numOrdenado;
			if (nums.size()>0)
			{
				
				strSql= new StringBuffer(W83bClsConstantes.CUARENTA);
				params= new ArrayList();
				
				strSql.append("UPDATE ");
				strSql.append(W83bCitacionesBD.sindicatosCitacion);
				strSql.append (" SET ");
				strSql.append(W83bCitacionesBD.dirSindicatoSindi);
				strSql.append(" = ? , ");
				strSql.append(W83bCitacionesBD.cpSindicatoSindi);
				strSql.append(" = ? , ");
				strSql.append(W83bCitacionesBD.provSindicatoSindi);
				strSql.append(" = ? , ");
				strSql.append(W83bCitacionesBD.muniSindicatoSindi);
				strSql.append(" = ? ");
				strSql.append(" WHERE ");
				strSql.append(W83bCitacionesBD.codSindicatoSindi).append(" = ? ");
				strSql.append(" AND ").append(W83bCitacionesBD.numImpugnacionSindi).append(" = ? ");
				strSql.append(" AND ").append(W83bCitacionesBD.anyoImpugnacionSindi).append(" = ? ");
				strSql.append(" AND ").append(W83bCitacionesBD.codTerritorioImpugnacionSindi).append(" = ? ");
				params.add(new Integer(param.getNumImpugnacion()));
				params.add(new Integer(param.getAnyoImpugnacion()));
				params.add(param.getTerritorioImpugnacion().toUpperCase());
	
				for(int i=0;i<nums.size();i++)
				{
					if(this.existeSindicato(param,(String)sindicatos.get("cod"+nums.get(i))))
					{
						params.add(0,(String)sindicatos.get("cod"+nums.get(i)));
						if (StringUtils.isNotEmpty((String)sindicatos.get("muni"+nums.get(i)))){
							params.add(0,(String)sindicatos.get("muni"+nums.get(i)));
						}else{
							params.add(0,W83bClsConstantes.NULL_STRING);
						}
						if (StringUtils.isNotEmpty((String)sindicatos.get("prov"+nums.get(i)))){
							params.add(0,(String)sindicatos.get("prov"+nums.get(i)));
						}else{
							params.add(0,W83bClsConstantes.NULL_STRING);
						}
						if (StringUtils.isNotEmpty((String)sindicatos.get("cp"+nums.get(i)))){
							params.add(0,(String)sindicatos.get("cp"+nums.get(i)));
						}else{
							params.add(0,W83bClsConstantes.NULL_STRING);
						}
						if (StringUtils.isNotEmpty((String)sindicatos.get("dir"+nums.get(i)))){
							params.add(0,(String)sindicatos.get("dir"+nums.get(i)));
						}else{
							params.add(0,W83bClsConstantes.NULL_STRING);
						}
						
						
						W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
						params.remove(0);
						params.remove(0);
						params.remove(0);
						params.remove(0);
						params.remove(0);
					}else{
						this.anyadirSindicatos(param,(String)sindicatos.get("cod"+nums.get(i)),(String)sindicatos.get("dir"+nums.get(i)),
								(String)sindicatos.get("prov"+nums.get(i)),	(String)sindicatos.get("muni"+nums.get(i)),(String)sindicatos.get("tipo"+nums.get(i)),(String)sindicatos.get("cp"+nums.get(i)));
					}
					//Actualizar los listados del bean
					
					
				}
					
				
			}			
			volcarMapaListas(param);	
		
	}
	
	public void editarInteresados(W83bCitacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto los promotores
		param.setCodsInteresados("");
		param.setNombreInteresados("");
		param.setDirInteresados("");
		param.setCpInteresados("");
		param.setProvInteresados("");
		param.setMuniInteresados("");
			HashMap interesados=param.getMapaInteresados();
			Set set=param.getMapaInteresados().keySet();
			List nums=new ArrayList();
			Iterator it=set.iterator();
			while(it.hasNext())
			{
				String key=(String)it.next();
				String num="";
				if(key.substring(0,3).equals("cod"))
						{
							num=key.substring(3,key.length());
							if(!"AUX".equals(num))
							{
								nums.add(num);
							}
						}
			}
			/*List numOrdenado=nums;
			int temporal;
			for (int i = 0; i < numOrdenado.size() - 1; i++) {
				for (int j = i+1; j < numOrdenado.size(); j++) {
					if (Integer.parseInt((String) numOrdenado.get(j)) < Integer.parseInt((String) numOrdenado.get(i))) {
						temporal = Integer.parseInt((String) numOrdenado.get(j));
						numOrdenado.set(j, numOrdenado.get(i));
						numOrdenado.set(i, temporal+"");
					}
				}
			}
			nums=numOrdenado;*/
			if (nums.size()>0)
			{
				
				strSql= new StringBuffer(W83bClsConstantes.CUARENTA);
				params= new ArrayList();
				
				strSql.append("UPDATE ");
				strSql.append(W83bInteresadosBD.tableInteresados);
				strSql.append (" SET ");
				strSql.append(W83bInteresadosBD.nombreInt);
				strSql.append(" = ? , ");
				strSql.append(W83bInteresadosBD.dirInt);
				strSql.append(" = ? , ");
				strSql.append(W83bInteresadosBD.cosposInt);
				strSql.append(" = ? , ");
				strSql.append(W83bInteresadosBD.munInt);
				strSql.append(" = ? , ");
				strSql.append(W83bInteresadosBD.provInt);
				strSql.append(" = ? ");
				strSql.append(" WHERE ");
				strSql.append(W83bInteresadosBD.idInt).append(" = ? ");
				strSql.append(" AND ").append(W83bInteresadosBD.numimpugInt).append(" = ? ");
				strSql.append(" AND ").append(W83bInteresadosBD.anoimpugInt).append(" = ? ");
				strSql.append(" AND ").append(W83bInteresadosBD.territInt).append(" = ? ");
	
				for(int i=0;i<nums.size();i++)
				{
					if(this.existeInteresado(param,(String)interesados.get("cod"+nums.get(i))))
					{
						params=new ArrayList();//NOPMD
						
						if (StringUtils.isNotEmpty((String)interesados.get("nom"+nums.get(i)))){
							params.add((String)interesados.get("nom"+nums.get(i)));
						}else{
							params.add(W83bClsConstantes.NULL_STRING);
						}
						if (StringUtils.isNotEmpty((String)interesados.get("dir"+nums.get(i)))){
							params.add((String)interesados.get("dir"+nums.get(i)));
						}else{
							params.add(W83bClsConstantes.NULL_STRING);
						}
						if (StringUtils.isNotEmpty((String)interesados.get("cp"+nums.get(i)))){
							params.add((String)interesados.get("cp"+nums.get(i)));
						}else{
							params.add(W83bClsConstantes.NULL_STRING);
						}
						if (StringUtils.isNotEmpty((String)interesados.get("muni"+nums.get(i)))){
							params.add((String)interesados.get("muni"+nums.get(i)));
						}else{
							params.add(W83bClsConstantes.NULL_STRING);
						}
						if (StringUtils.isNotEmpty((String)interesados.get("prov"+nums.get(i)))){
							params.add((String)interesados.get("prov"+nums.get(i)));
						}else{
							params.add(W83bClsConstantes.NULL_STRING);
						}
						params.add((String)interesados.get("cod"+nums.get(i)));
						params.add(new Integer(param.getNumImpugnacion()));//NOPMD
						params.add(new Integer(param.getAnyoImpugnacion()));//NOPMD
						params.add(param.getTerritorioImpugnacion().toUpperCase());
						W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
					}else{
						String strSecuencia = "";
						strSecuencia="SELECT "+W83bInteresadosBD.secuenciaInteresados+".NEXTVAL FROM DUAL";
						List psecuencia=new ArrayList();//NOPMD
						List listasecuencia=W83bDataBase.executeSimpleQuery(strSecuencia, psecuencia ,param.getUsuarioBean());
						this.anyadirInteresados(param,String.valueOf(listasecuencia.get(0)),(String)interesados.get("nom"+nums.get(i)),(String)interesados.get("dir"+nums.get(i)),
								(String)interesados.get("prov"+nums.get(i)),(String)interesados.get("muni"+nums.get(i)),(String)interesados.get("cp"+nums.get(i)));
					}
					//Actualizar los listados del bean
					
					
				}
					
				
			}			
			volcarMapaListasInteresados(param);	
		
	}
	
	public W83bCitacionBean anyadirCitaciones(W83bCitacionBean param) throws Exception {
		String formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO;
		
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
		{
			
			formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA;
		}
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bCitacionesBD.tableCitaciones);
		
		strSql.append("(");
		
		strSql.append(W83bCitacionesBD.ano_impug);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.n_impug);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.c_territ);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.id_centro);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.hora_citacionI);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.hora_citacionF);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.mesa);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.dniImpugnante);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.nombreImpugnante);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.dirImpugnante);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.cpImpugnante);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.provinciaImpugnante);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.municipioImpugnante);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.dir_orig);
		strSql.append(",");
		strSql.append(W83bCitacionesBD.orden_sindi);
		
		strSql.append(")");
		
		strSql.append(" VALUES (?,?,?,?,to_date(?,'"+formatoFechaCompleta+"')," +
				"to_date(?,'"+formatoFechaCompleta+"'),?,?,?,?,?,?,?,?,?)");
		params.add(new Integer(param.getAnyoImpugnacion()));
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		
		params=this.aniadirParametrosCitacion( param, params);

		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
	
		return param;
	}
	private List aniadirParametrosCitacion(W83bCitacionBean param,List parametros)
	{
		List params=parametros;
		if (StringUtils.isNotEmpty(param.getIdCentroTrabajo())){
			params.add(param.getIdCentroTrabajo());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);}
		if (StringUtils.isNotEmpty(param.getFechaCitacion())
				&& StringUtils.isNotEmpty(param.getHoraCitacionInicio())){
			params.add(param.getFechaCitacion()+" "+param.getHoraCitacionInicio());
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getFechaCitacion())
				&& StringUtils.isNotEmpty(param.getHoraCitacionFinal())){
			params.add(param.getFechaCitacion()+" "+param.getHoraCitacionFinal());
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getMesa())){
			params.add(param.getMesa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDniImpug())){
			params.add(param.getDniImpug());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getNombreImpug())){
			params.add(param.getNombreImpug());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDirImpug())){
				params.add(param.getDirImpug());
		}else{
				params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCpImpug())){
			params.add(param.getCpImpug());
		}else{
				params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getProvinciaImpug())){
			params.add(param.getProvinciaImpug());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getMunicipioImpug())){
			params.add(param.getMunicipioImpug());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCentroSel())){
			
			params.add(param.getCentroSel());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (param.getMapaSindicatos()!=null){
			HashMap sindicatos=param.getMapaSindicatos();
			Set set=param.getMapaSindicatos().keySet();
			List nums=new ArrayList();
			Iterator it=set.iterator();
			while(it.hasNext())
			{
				String key=(String)it.next();
				String num="";
				if(key.substring(0,3).equals("cod"))
						{
							num=key.substring(3,key.length());
							if(!("AUX").equals(num))
							{
								nums.add(num);
							}
						}
			}
			
			List numOrdenado=nums;
			int temporal;
			for (int i = 0; i < numOrdenado.size() - 1; i++) {
				for (int j = i+1; j < numOrdenado.size(); j++) {
					if (Integer.parseInt((String) numOrdenado.get(j)) < Integer.parseInt((String) numOrdenado.get(i))) {
						temporal = Integer.parseInt((String) numOrdenado.get(j));
						numOrdenado.set(j, numOrdenado.get(i));
						numOrdenado.set(i, temporal+"");
					}
				}
			}
			nums=numOrdenado;
			StringBuffer cadenaSindicatos=new StringBuffer();
			for(int i=0;i<nums.size();i++){
				if(i==0){
					cadenaSindicatos.append((String)sindicatos.get("cod"+nums.get(i)));
				}else{
					cadenaSindicatos.append("@").append((String)sindicatos.get("cod"+nums.get(i)));
				}
			}
			params.add(cadenaSindicatos.toString());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		return params;
	}
	public void editarCitaciones(W83bCitacionBean param) throws Exception {
		
		
		String formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO;
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
		{
			
			formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA;
		}
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bCitacionesBD.tableCitaciones);
		strSql.append (" SET ");
		strSql.append(W83bCitacionesBD.id_centro);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.hora_citacionI);
		strSql.append(" = to_date(?,'"+formatoFechaCompleta+"') , ");
		strSql.append(W83bCitacionesBD.hora_citacionF);
		strSql.append(" = to_date(?,'"+formatoFechaCompleta+"') , ");
		strSql.append(W83bCitacionesBD.mesa);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.dniImpugnante);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.nombreImpugnante);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.dirImpugnante);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.cpImpugnante);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.provinciaImpugnante);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.municipioImpugnante);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.dir_orig);
		strSql.append(" = ? , ");
		strSql.append(W83bCitacionesBD.orden_sindi);
		strSql.append(" = ?  ");
		
		
		strSql.append(" WHERE ");
		strSql.append(W83bCitacionesBD.ano_impug).append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesBD.n_impug).append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesBD.c_territ).append(" = ? ");
	
		
		params=this.aniadirParametrosCitacion( param, params);
		params.add(new Integer(param.getAnyoImpugnacion()));
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
	
	}

	
	
	


	public W83bCitacionBean obtenerDatosBasicosCitacion(HashMap param, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		String [] cod=((String)param.get("codSelec")).split("_");
		
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String formatoFecha=W83bClsConstantes.FORMATO_FECHA_CASTELLANO;
		if(param.get("strIdioma").equals(W83bClsConstantes.CONSTANTE_EUSKARA))
		{
			
			formatoFecha=W83bClsConstantes.FORMATO_FECHA_EUSKARA;
		}
		strSql.append("SELECT ");
		strSql.append(W83bCitacionesVistaBD.NCITACION).append(", ");
		strSql.append(W83bCitacionesVistaBD.codTerritorioImpugnacion).append(", ");
		strSql.append(W83bCitacionesVistaBD.anyoImpugnacion).append(", ");
		strSql.append(W83bCitacionesVistaBD.numImpugnacion).append(", TO_CHAR(");
		strSql.append(W83bCitacionesVistaBD.FECHAIMPUGNACION).append(",'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+ "') AS ").append(W83bCitacionesVistaBD.FECHAIMPUGNACION).append(" ,");
		strSql.append(W83bCitacionesVistaBD.MESA).append(", ");
		strSql.append(W83bCitacionesVistaBD.DIRORIG).append(", ");
		strSql.append(W83bCitacionesVistaBD.DNIIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.NOMBREIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.DIRIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.CPIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.PROVIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.PROVIMPUGTXTC).append(", ");
		strSql.append(W83bCitacionesVistaBD.PROVIMPUGTXTE).append(", ");
		strSql.append(W83bCitacionesVistaBD.MUNIIMPUG).append(", ");
		strSql.append(W83bCitacionesVistaBD.MUNIIMPUGTXTC).append(", ");
		strSql.append(W83bCitacionesVistaBD.MUNIIMPUGTXTE).append(", ");
		strSql.append(W83bCitacionesVistaBD.DATOSSINDICATOS).append(", ");
		strSql.append(W83bCitacionesVistaBD.DATOSINTERESADOS).append(", ");
		strSql.append(W83bCitacionesVistaBD.CODSSINDICATOS).append(", ");
		strSql.append(W83bCitacionesVistaBD.ABRSINDICATOS).append(", TO_CHAR( ");
		strSql.append(W83bCitacionesVistaBD.HORACITACIONI).append(",'"+formatoFecha+"') AS ").append(W83bCitacionesVistaBD.FECHACITACION).append(", TO_CHAR(  ");
		strSql.append(W83bCitacionesVistaBD.HORACITACIONI).append(",'HH24:MI') AS ").append(W83bCitacionesVistaBD.HORACITACIONI).append(", TO_CHAR( ");
		strSql.append(W83bCitacionesVistaBD.HORACITACIONF).append(",'HH24:MI') AS ").append(W83bCitacionesVistaBD.HORACITACIONF).append(", ");
		strSql.append(W83bCitacionesVistaBD.NCENTRO).append(", ");
		strSql.append(W83bCitacionesVistaBD.RAZONSOCIAL).append(", ");
		strSql.append(W83bCitacionesVistaBD.DIRCENTRO).append(", ");
		strSql.append(W83bCitacionesVistaBD.CPCENTRO).append(", ");
		strSql.append(W83bCitacionesVistaBD.RAZONSOCIAL).append(", ");
		strSql.append(W83bCitacionesVistaBD.codProvincia).append(", ");
		strSql.append(W83bCitacionesVistaBD.codMunicipio).append(", ");
		strSql.append(W83bCitacionesVistaBD.centroProvinciaTxtC).append(", ");
		strSql.append(W83bCitacionesVistaBD.centroProvinciaTxtE).append(", ");
		strSql.append(W83bCitacionesVistaBD.centroMunicipioTxtC).append(", ");
		strSql.append(W83bCitacionesVistaBD.centroMunicipioTxtE).append(", ");
		strSql.append(W83bCitacionesVistaBD.IDCENTRO).append(", ");
		strSql.append(W83bCitacionesVistaBD.CIF).append(", ");
		strSql.append(W83bCitacionesVistaBD.ORDENSIN).append(", ");
		strSql.append(W83bCitacionesVistaBD.NACTA);
		
		
		strSql.append(" FROM ").append(W83bCitacionesVistaBD.citacionesView);
		
		strSql.append(" WHERE ").append(W83bCitacionesVistaBD.codTerritorioImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesVistaBD.anyoImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesVistaBD.numImpugnacion).append(" = ?");
		
			
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bCitacionBean.class,null, null);
		W83bCitacionBean citacion=null;
		if(lista.size()>0)
		{	
			citacion=(W83bCitacionBean)lista.get(0);
			citacion.setCodSelec((String)param.get("codSelec"));
			return this.obtenerDatosPreavisoOrig(citacion);
		}else{
			return citacion;
		}
		
		
		
}
	public HashMap obtenerDatosComunicacionCitacion(HashMap param, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		String sexo="";
		HashMap resul=new HashMap();
		resul.put("nombreFirmante", "");
		String firmante=(String)param.get("firmante");
		String territorio=(String)param.get("territorio");
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		
		strSql.append(W83bRespAreaBD.responsable).append(" AS NOMBRE ");
		strSql.append(",");	
		strSql.append(W83bRespAreaBD.sexo).append(" AS SEXO ");
		// TODO Auto-generated method stub
		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable);
		
		strSql.append(" WHERE ").append(W83bRespAreaBD.territorio).append(" = ?");
		strSql.append(" AND ").append(W83bRespAreaBD.perfil).append(" = ?");
		params.add(territorio);		
		params.add(firmante);		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul.put("nombreFirmante", ((HashMap)lista.get(0)).get("NOMBRE"));
			sexo=(String)((HashMap)lista.get(0)).get("SEXO");
			
		}
		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		
		strSql.append("SELECT ");
		if (W83bClsConstantes.CONSTANTE_VARON.equals(sexo)){
			strSql.append("'El '").append("||").append(W83bRespAreaBD.perfildesc).append(" AS DESCC, ");
		}
		else if (W83bClsConstantes.CONSTANTE_MUJER.equals(sexo)){
			strSql.append("'La '").append("||").append(W83bRespAreaBD.perfilfemenino).append(" AS DESCC, ");
		}
		else{
			strSql.append("'El '").append("||").append(W83bRespAreaBD.perfildesc).append("||'/'||").append(W83bRespAreaBD.perfilfemenino).append(" AS DESCC, ");
		}
		strSql.append(W83bRespAreaBD.perfildese).append(" AS DESCE ");
			
		
		// TODO Auto-generated method stub
		strSql.append(" FROM ").append(W83bRespAreaBD.perfilesTable);
		
		strSql.append(" WHERE ").append(W83bRespAreaBD.codperfil).append(" = ?");
		
		params.add(firmante);		
		
		lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
		
		if(lista.size()>0)
		{	
			resul.put("cargoFirmanteCast", ((HashMap)lista.get(0)).get("DESCC"));
			resul.put("cargoFirmanteEusk", ((HashMap)lista.get(0)).get("DESCE"));
			
		}
		return resul;
		
		
		
		
}
	public HashMap obtenerDatosAcuseCitacion(HashMap param, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		HashMap resul=new HashMap();
		
		String municipios=(String)param.get("codMunicipio");
		String territorios=(String)param.get("codTerritorio");
		
		String[] arrayMunicipios=municipios.split(",");
		String[] arrayTerritorios=territorios.split(",");
		String[] txtMunicipiosE=new String[arrayMunicipios.length];
		String[] txtMunicipiosC=new String[arrayMunicipios.length];
		String[] txtTerritoriosE=new String[arrayTerritorios.length];
		String[] txtTerritoriosC=new String[arrayTerritorios.length];
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		StringBuffer strSql2 = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ");
		
		strSql.append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.nomMunic_Cast).append(" AS MUNI_C, ");
		strSql.append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.nomMunic_Eusk).append(" AS MUNI_E, ");
		strSql.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Cast).append(" AS PROV_C, ");
		strSql.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Eusk).append(" AS PROV_E ");
		
	
		
		// TODO Auto-generated method stub
		strSql.append(" FROM ").append(W83bMunicipiosBD.municipiosTable).append(", ").append(W83bProvinciasBD.provinciasTable);
		
		strSql.append(" WHERE ").append(W83bMunicipiosBD.codProvincia).append(" = ?");
		strSql.append(" AND  ").append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.codMunic).append(" = ?");
		strSql.append(" AND  ").append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.codProvincia).append(" = ").append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.codProvinc);
		
		strSql2.append("SELECT ");
		
		strSql2.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Cast).append(" AS PROV_C, ");
		strSql2.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Eusk).append(" AS PROV_E ");
		
	
		
		// TODO Auto-generated method stub
		strSql2.append(" FROM ").append(W83bProvinciasBD.provinciasTable);
		strSql2.append(" WHERE ").append(W83bProvinciasBD.codProvinc).append(" = ?");
		
		
		List params = new ArrayList();
		List params2 = new ArrayList();
		for(int i=0;i<arrayMunicipios.length && i<arrayTerritorios.length;i++)
		{
			params = new ArrayList();//NOPMD
			params.add(arrayTerritorios[i]);
			params.add(arrayMunicipios[i]);
			List lista = W83bDataBase.executeQuery(strSql.toString(), params, null);
			
			if(lista.size()>0)
			{	
				txtMunicipiosC[i]=(String)((HashMap)lista.get(0)).get("MUNI_C");
				txtMunicipiosE[i]=(String)((HashMap)lista.get(0)).get("MUNI_E");
				txtTerritoriosC[i]=(String)((HashMap)lista.get(0)).get("PROV_C");
				txtTerritoriosE[i]=(String)((HashMap)lista.get(0)).get("PROV_E");
				
			}
			else{
				params2 = new ArrayList();//NOPMD
				params2.add(arrayTerritorios[i]);
				List lista2 = W83bDataBase.executeQuery(strSql2.toString(), params2, null);
				
				if(lista2.size()>0)
				{	
					txtTerritoriosC[i]=(String)((HashMap)lista2.get(0)).get("PROV_C");
					txtTerritoriosE[i]=(String)((HashMap)lista2.get(0)).get("PROV_E");
					
				}
			}
			
		}
		
		resul.put("txtMunicipiosC",txtMunicipiosC);
		resul.put("txtMunicipiosE",txtMunicipiosE);
		resul.put("txtTerritoriosC",txtTerritoriosC);
		resul.put("txtTerritoriosE",txtTerritoriosE);
		return resul;
		
		
		
		
}
	public boolean borrarCitacion(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bCitacionesBD.tableCitaciones);
		strSql.append(" WHERE ");
		strSql.append(W83bCitacionesBD.c_territ);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesBD.ano_impug);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesBD.n_impug);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	
	public boolean borrarTramite(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.tramitesImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.codTramite);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.codFase);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionTram);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionTram);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionTram);
		strSql.append(" = ? ");
		
		params.add(new String(String.valueOf(W83bClsConstantes.TRAMITE_CITACION_ARBITRAL)));		
		params.add(new Integer(String.valueOf(W83bClsConstantes.FASE_IMPUGNACION)));
		params.add(new Integer(cod[2]));
		params.add(new Integer(cod[0]));
		params.add(new Integer(cod[1]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
		
	}
	
	public boolean borrarSindicatos(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bCitacionesBD.sindicatosCitacion);
		strSql.append(" WHERE ");
		strSql.append(W83bCitacionesBD.codTerritorioImpugnacionSindi);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesBD.anyoImpugnacionSindi);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bCitacionesBD.numImpugnacionSindi);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
		

		return true;
	}
	
	public boolean borrarInteresados(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bInteresadosBD.tableInteresados);
		strSql.append(" WHERE ");
		strSql.append(W83bInteresadosBD.territInt);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bInteresadosBD.anoimpugInt);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bInteresadosBD.numimpugInt);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
		

		return true;
	}
	
	public void borrarSindicatosCitaciones(W83bCitacionBean param)
			throws Exception {


		if (StringUtils.isNotEmpty(param.getCodsSindicatosBorrados()))
		{
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bCitacionesBD.sindicatosCitacion);
			strSql.append(" WHERE ");
			strSql.append(W83bCitacionesBD.numImpugnacionSindi).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bCitacionesBD.anyoImpugnacionSindi).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bCitacionesBD.codTerritorioImpugnacionSindi).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bCitacionesBD.codSindicatoSindi).append(" = ?");

			String [] codsSindicatosBorrados=param.getCodsSindicatosBorrados().split("\\?");
			
			params.add(new Integer(param.getNumImpugnacion()));
			params.add(new Integer(param.getAnyoImpugnacion()));
			params.add(new Integer(param.getTerritorioImpugnacion()));
			
			for (int i=0;i<codsSindicatosBorrados.length;i++)
			{
				params.add(codsSindicatosBorrados[i]);
				
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.remove(params.size()-1);
			}
		}
		
	}

	public void borrarInteresadosCitaciones(W83bCitacionBean param)
throws Exception {


if (StringUtils.isNotEmpty(param.getCodsInteresadosBorrados()))
{
	StringBuffer strSql = new StringBuffer();
	List params = new ArrayList();
	
	strSql.append("DELETE FROM ");
	strSql.append(W83bInteresadosBD.tableInteresados);
	strSql.append(" WHERE ");
	strSql.append(W83bInteresadosBD.numimpugInt).append(" = ?");
	strSql.append(" AND ");
	strSql.append(W83bInteresadosBD.anoimpugInt).append(" = ?");
	strSql.append(" AND ");
	strSql.append(W83bInteresadosBD.territInt).append(" = ?");
	strSql.append(" AND ");
	strSql.append(W83bInteresadosBD.idInt).append(" = ?");

	String[] codsIntBorrados=((String.valueOf(param.getCodsInteresadosBorrados())).replaceAll(",","?").split("\\?"));
	
	params.add(new Integer(param.getNumImpugnacion()));
	params.add(new Integer(param.getAnyoImpugnacion()));
	params.add(new Integer(param.getTerritorioImpugnacion()));
	
	for (int i=0;i<codsIntBorrados.length;i++)
	{
		params.add(codsIntBorrados[i]);
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		params.remove(params.size()-1);
	}
}

}
	
	public boolean existeCitacion(HashMap param)	throws Exception {
		W83bCitacionBean bean=new W83bCitacionBean();
		bean.setTerritorioImpugnacion((String)param.get("cterritorio"));
		bean.setAnyoImpugnacion((String)param.get("anio"));
		bean.setNumImpugnacion((String)param.get("num"));
		return this.existeCitacion(bean);
	}
		
	public boolean existeCitacion(W83bCitacionBean param)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT * FROM ").append( W83bCitacionesBD.tableCitaciones);
	
		
		strSql.append(" WHERE ").append(W83bCitacionesBD.ano_impug).append(" = ? ");
		strSql.append(" AND ").append(W83bCitacionesBD.n_impug).append(" = ? ");
		strSql.append(" AND ").append(W83bCitacionesBD.c_territ).append(" = ? ");
		params.add(new Integer(param.getAnyoImpugnacion()));		
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(lista.size()>0){
			return true;
		}
		
		return false;
	}
	public boolean existeInteresado(W83bCitacionBean param,String id)
	throws Exception {
	
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();			
			strSql.append("SELECT * FROM ").append( W83bInteresadosBD.viewInteresados);			
			strSql.append(" WHERE ").append(W83bInteresadosBD.anoimpugInt).append(" = ? ");
			strSql.append(" AND ").append(W83bInteresadosBD.numimpugInt).append(" = ? ");
			strSql.append(" AND ").append(W83bInteresadosBD.territInt).append(" = ? ");
			strSql.append(" AND ").append(W83bInteresadosBD.idInt).append(" = ? ");			
			params.add(new Integer(param.getAnyoImpugnacion()));		
			params.add(new Integer(param.getNumImpugnacion()));
			params.add(param.getTerritorioImpugnacion());
			params.add(id);

			List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
			if(lista.size()>0){
				return true;
			}
			return false;	
	}
	public boolean existeSindicato(W83bCitacionBean param,String sindi)
	throws Exception {
	
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();			
			strSql.append("SELECT * FROM ").append( W83bCitacionesBD.sindicatosCitacion);			
			strSql.append(" WHERE ").append(W83bCitacionesBD.anyoImpugnacionSindi).append(" = ? ");
			strSql.append(" AND ").append(W83bCitacionesBD.numImpugnacionSindi).append(" = ? ");
			strSql.append(" AND ").append(W83bCitacionesBD.codTerritorioImpugnacionSindi).append(" = ? ");
			strSql.append(" AND ").append(W83bCitacionesBD.codSindicatoSindi).append(" = ? ");			
			params.add(new Integer(param.getAnyoImpugnacion()));		
			params.add(new Integer(param.getNumImpugnacion()));
			params.add(param.getTerritorioImpugnacion());
			params.add(sindi);

			List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
			if(lista.size()>0){
				return true;
			}
			return false;	
	}
	public W83bImpugnacionBean obtenerDatosBasicosImpugnacion(HashMap mapaResultado) throws Exception {

			// TODO Auto-generated method stub
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("SELECT ");
			strSql.append(W83bImpugnacionesVistaBD.NIMPUGNACION).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.anyoActa).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.numActa).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.VERSION).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.NPREAVISO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.anyoPreaviso).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.numPreaviso).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.NACTA).append(", TO_CHAR(");
			strSql.append(W83bImpugnacionesVistaBD.fimpugnacionDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FIMPUGNACION).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.NOMBREARBITRO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.ARBITRO).append(", TO_CHAR(");
			strSql.append(W83bImpugnacionesVistaBD.fenvioarbitroDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FENVIOARBITRO).append(", TO_CHAR(");
			strSql.append(W83bImpugnacionesVistaBD.fdesestimientoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FDESESTIMIENTO).append(", TO_CHAR(");
			strSql.append(W83bImpugnacionesVistaBD.fenviojuzgadoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FENVIOJUZGADO).append(", TO_CHAR(");
			strSql.append(W83bImpugnacionesVistaBD.fsentenciaDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FSENTENCIA).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.decision).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.asunto).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.anyoLaudo).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.numLaudo).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.NLAUDO).append(", TO_CHAR(");
			strSql.append(W83bImpugnacionesVistaBD.flaudoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FLAUDO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.TIPOIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DESCRESULTADO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DESERESULTADO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.RESULTADO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DESCTIPOIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DESETIPOIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.NREGISTRO).append(", TO_CHAR(");
			strSql.append(W83bImpugnacionesVistaBD.fregistroDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FREGISTRO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.CODSINDICATOS).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DESCSINDICATOS).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DESCVOCES).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DESEVOCES).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.CODVOCES).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.NCENTRO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.RAZONSOCIAL).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.dircentro).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.codProvincia).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.codMunicipio).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.centroMunicipioTxtC).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.centroMunicipioTxtE).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.centroProvinciaTxtC).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.centroProvinciaTxtE).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.MUNIIMPUGTXTE).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.PROVIMPUGTXTE).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.MUNIIMPUGTXTC).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.PROVIMPUGTXTC).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.PROVIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DNIIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.NOMBREIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.DIRIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.CPIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.MUNIIMPUG).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.IDCENTRO).append(", ");
			strSql.append(W83bImpugnacionesVistaBD.CIF);

			

			
			
			strSql.append(" FROM ").append(W83bImpugnacionesVistaBD.impugnacionesView);
			
			strSql.append(" WHERE ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(" = ?");
			String idioma=(String)mapaResultado.get("idioma");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			params.add((String)mapaResultado.get("cterritorio"));
			params.add((String)mapaResultado.get("anio"));
			params.add((String)mapaResultado.get("num"));
				
			
			
			List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bImpugnacionBean.class,null, null);
			if(lista.size()==0)
			{
				return new W83bImpugnacionBean();
			}
			W83bImpugnacionBean bean=(W83bImpugnacionBean)lista.get(0);
				
			
				// TODO Auto-generated method stub
				 strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
				 params = new ArrayList();
					
					if(bean.getActaPreaviso().equals("preaviso"))
							{
									strSql.append("SELECT ");
									strSql.append(W83bPreavisosBD.num_centro_053).append(", ");
									strSql.append(W83bPreavisosBD.raz_social_053).append(", ");
									strSql.append(W83bPreavisosBD.prov_alt_053).append(", ");
									strSql.append(W83bPreavisosBD.mun_alt_053).append(", ");
									strSql.append(W83bPreavisosBD.nif_centro_053).append(", ");
									strSql.append(W83bPreavisosBD.dir_alt_053);
									
					
									strSql.append(" FROM ").append(W83bPreavisosBD.preavisos_originalesTable);
									
									strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_053).append(" = ?");
									strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_053).append(" = ?");
									strSql.append(" AND ").append(W83bPreavisosBD.c_territ_053).append(" = ?");
									
									
									params.add(bean.getAnyoPreaviso());
									params.add(bean.getNumPreaviso());
									params.add(bean.getTerritorioImpugnacion());
									
							}else if(bean.getActaPreaviso().equals("acta"))
							{
								strSql.append("SELECT ");
								strSql.append(W83bPreavisosBD.num_centro_053).append(", ");
								strSql.append(W83bPreavisosBD.raz_social_053).append(", ");
								strSql.append(W83bPreavisosBD.prov_alt_053).append(", ");
								strSql.append(W83bPreavisosBD.mun_alt_053).append(", ");
								strSql.append(W83bPreavisosBD.nif_centro_053).append(", ");
								strSql.append(W83bPreavisosBD.dir_alt_053);
								
				
								strSql.append(" FROM ").append(W83bPreavisosBD.preavisos_originalesTable);
								strSql.append(",").append(W83bPreavisosBD.preavisosTable);
								
								strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_053).append(" = ").append( W83bPreavisosBD.ano_preaviso_037);
								strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_053).append(" = ").append(W83bPreavisosBD.n_preaviso_037);
								strSql.append(" AND ").append(W83bPreavisosBD.c_territ_053).append(" = ").append(W83bPreavisosBD.c_territ_037);
								strSql.append(" AND ").append(W83bPreavisosBD.c_territ_037).append(" = ?");
								strSql.append(" AND ").append(W83bPreavisosBD.ano_acta_037).append(" = ?");
								strSql.append(" AND ").append(W83bPreavisosBD.n_acta_037).append(" = ?");
								
								params.add(bean.getTerritorioImpugnacion());
								params.add(bean.getAnyoPreaviso());
								params.add(bean.getNumPreaviso());
								
							}

								
			lista = W83bDataBase.executeQuery(strSql.toString(),params,null);
			if(lista.size()==0)
			{
				return bean;
			}
			HashMap rs=(HashMap)lista.get(0);
			bean.getCentroTrabajoPrevOrig().setNumCentro(String.valueOf(rs.get(W83bPreavisosBD.num_centro_053)));
			bean.getCentroTrabajoPrevOrig().setCifnif((String)rs.get( W83bPreavisosBD.nif_centro_053));
			bean.getCentroTrabajoPrevOrig().setRazonSocial((String)rs.get( W83bPreavisosBD.raz_social_053));
			bean.getCentroTrabajoPrevOrig().setCodTerritorio((String)rs.get(W83bPreavisosBD.prov_alt_053));
			bean.getCentroTrabajoPrevOrig().setCodMunicipio((String)rs.get( W83bPreavisosBD.mun_alt_053));
			bean.getCentroTrabajoPrevOrig().setDomicilio((String)rs.get( W83bPreavisosBD.dir_alt_053));
			
					
			return bean;
	}
	
	public W83bCitacionBean obtenerDatosPreavisoOrig(W83bCitacionBean citacion) throws Exception {

		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NPREAVISO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoPreaviso).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numPreaviso).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoActa).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numActa).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.VERSION).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NACTA);
		
		strSql.append(" FROM ").append(W83bImpugnacionesVistaBD.impugnacionesView);
		
		strSql.append(" WHERE ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(" = ?");
		
		params.add(citacion.getTerritorioImpugnacion());
		params.add(citacion.getAnyoImpugnacion());
		params.add(citacion.getNumImpugnacion());
			
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bImpugnacionBean.class,null, null);
		if(lista.size()==0)
		{
			return citacion;
		}else{
			
			W83bImpugnacionBean bean=(W83bImpugnacionBean)lista.get(0);
			strSql=new StringBuffer(W83bClsConstantes.CUARENTA);
			params=new ArrayList();
			if(bean.getActaPreaviso().equals("preaviso"))
				{
					strSql.append("SELECT ");
					strSql.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Eusk).append(" AS PROV_E, ");
					strSql.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Cast).append(" AS PROV_C, ");
					strSql.append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.nomMunic_Eusk).append(" AS MUNI_E, ");
					strSql.append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.nomMunic_Cast).append(" AS MUNI_C, ");
					strSql.append(W83bPreavisosBD.raz_social_053).append(", ");
					strSql.append(W83bPreavisosBD.num_centro_053).append(", ");
					strSql.append(W83bPreavisosBD.raz_social_053).append(", ");
					strSql.append(W83bPreavisosBD.prov_alt_053).append(", ");
					strSql.append(W83bPreavisosBD.mun_alt_053).append(", ");
					strSql.append(W83bPreavisosBD.nif_centro_053).append(", ");
					strSql.append(W83bPreavisosBD.codPos_alt_053).append(", ");
					strSql.append(W83bPreavisosBD.dir_alt_053);
					
					strSql.append(" FROM ").append(W83bPreavisosBD.preavisos_originalesTable).append(", ");
					strSql.append(W83bProvinciasBD.provinciasTable).append(", ");
					strSql.append(W83bMunicipiosBD.municipiosTable);
								
					strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_053).append(" = ?");
					strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_053).append(" = ?");
					strSql.append(" AND ").append(W83bPreavisosBD.c_territ_053).append(" = ?");
					strSql.append(" AND ").append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.codMunic).append(" = ").append(W83bPreavisosBD.mun_alt_053);
					strSql.append(" AND ").append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.codProvincia).append(" = ").append(W83bPreavisosBD.prov_alt_053);
					strSql.append(" AND ").append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.codProvinc).append(" = ").append(W83bPreavisosBD.prov_alt_053);
								
					params.add(bean.getAnyoPreaviso());
					params.add(bean.getNumPreaviso());
					params.add(bean.getTerritorioImpugnacion());
								
			}else if(bean.getActaPreaviso().equals("acta"))
			{
					strSql.append("SELECT ");
					strSql.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Eusk).append(" AS PROV_E, ");
					strSql.append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.nomProvinc_Cast).append(" AS PROV_C, ");
					strSql.append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.nomMunic_Eusk).append(" AS MUNI_E, ");
					strSql.append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.nomMunic_Cast).append(" AS MUNI_C, ");
					strSql.append(W83bPreavisosBD.num_centro_053).append(", ");
					strSql.append(W83bPreavisosBD.raz_social_053).append(", ");
					strSql.append(W83bPreavisosBD.prov_alt_053).append(", ");
					strSql.append(W83bPreavisosBD.mun_alt_053).append(", ");
					strSql.append(W83bPreavisosBD.nif_centro_053).append(", ");
					strSql.append(W83bPreavisosBD.codPos_alt_053).append(", ");
					strSql.append(W83bPreavisosBD.dir_alt_053);
					
					strSql.append(" FROM ").append(W83bPreavisosBD.preavisos_originalesTable);
					strSql.append(",").append(W83bPreavisosBD.preavisosTable).append(", ");
					strSql.append(W83bProvinciasBD.provinciasTable).append(", ");
					strSql.append(W83bMunicipiosBD.municipiosTable);
					
					strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_053).append(" = ").append( W83bPreavisosBD.ano_preaviso_037);
					strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_053).append(" = ").append(W83bPreavisosBD.n_preaviso_037);
					strSql.append(" AND ").append(W83bPreavisosBD.c_territ_053).append(" = ").append(W83bPreavisosBD.c_territ_037);
					strSql.append(" AND ").append(W83bPreavisosBD.c_territ_037).append(" = ?");
					strSql.append(" AND ").append(W83bPreavisosBD.ano_acta_037).append(" = ?");
					strSql.append(" AND ").append(W83bPreavisosBD.n_acta_037).append(" = ?");
					strSql.append(" AND ").append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.codMunic).append(" = ").append(W83bPreavisosBD.mun_alt_053);
					strSql.append(" AND ").append(W83bMunicipiosBD.municipiosTable).append(".").append(W83bMunicipiosBD.codProvincia).append(" = ").append(W83bPreavisosBD.prov_alt_053);
					strSql.append(" AND ").append(W83bProvinciasBD.provinciasTable).append(".").append(W83bProvinciasBD.codProvinc).append(" = ").append(W83bPreavisosBD.prov_alt_053);
					
					params.add(bean.getTerritorioImpugnacion());
					params.add(bean.getAnyoPreaviso());
					params.add(bean.getNumPreaviso());
					
				}

							
			lista = W83bDataBase.executeQuery(strSql.toString(),params,null);
			if(lista.size()==0)
			{
				return citacion;
			}
		HashMap rs=(HashMap)lista.get(0);
		
		citacion.getCentroTrabajoPrevOrig().setNumCentro(String.valueOf(rs.get(W83bPreavisosBD.num_centro_053)));
		citacion.getCentroTrabajoPrevOrig().setCifnif((String)rs.get( W83bPreavisosBD.nif_centro_053));
		citacion.getCentroTrabajoPrevOrig().setRazonSocial((String)rs.get( W83bPreavisosBD.raz_social_053));
		citacion.getCentroTrabajoPrevOrig().setCodTerritorio((String)rs.get(W83bPreavisosBD.prov_alt_053));
		citacion.getCentroTrabajoPrevOrig().setCodMunicipio((String)rs.get( W83bPreavisosBD.mun_alt_053));
		citacion.getCentroTrabajoPrevOrig().setDomicilio((String)rs.get( W83bPreavisosBD.dir_alt_053));
		citacion.getCentroTrabajoPrevOrig().setCodPostal((String)rs.get( W83bPreavisosBD.codPos_alt_053));
		citacion.getCentroTrabajoPrevOrig().setTerritorio((String)rs.get( "PROV_C"));
		citacion.getCentroTrabajoPrevOrig().setTerritorio_eusk((String)rs.get( "PROV_E"));
		citacion.getCentroTrabajoPrevOrig().setMunicipio((String)rs.get( "MUNI_C"));
		citacion.getCentroTrabajoPrevOrig().setMunicipio_eusk((String)rs.get( "MUNI_E"));
			return citacion;
			
		}
	
		
				
}

	public List obtenerCitas(HashMap param) throws Exception {
	
	
	// TODO Auto-generated method stub
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	String formatoFecha=W83bClsConstantes.FORMATO_FECHA_CASTELLANO;
	if(param.get("strIdioma").equals(W83bClsConstantes.CONSTANTE_EUSKARA))
	{
		
		formatoFecha=W83bClsConstantes.FORMATO_FECHA_EUSKARA;
	}
	strSql.append("SELECT ");
	
	strSql.append(" TO_CHAR(  ");
	strSql.append(W83bCitacionesVistaBD.HORACITACIONI).append(",'HH24:MI') AS ").append(W83bCitacionesVistaBD.HORACITACIONI).append(", TO_CHAR( ");
	strSql.append(W83bCitacionesVistaBD.HORACITACIONF).append(",'HH24:MI') AS ").append(W83bCitacionesVistaBD.HORACITACIONF);
	
	
	
	strSql.append(" FROM ").append(W83bCitacionesVistaBD.citacionesView);
	
	strSql.append(" WHERE ").append("TO_CHAR(").append(W83bCitacionesVistaBD.HORACITACIONI).append(",'"+formatoFecha+"') ").append(" = ?");
	strSql.append(" AND ").append(W83bCitacionesVistaBD.codTerritorioImpugnacion).append(" = ? ");
	if(param.get("excluir")!=null && param.get("excluir").equals("true"))
	{
		strSql.append(" AND (").append(W83bCitacionesVistaBD.anyoImpugnacion).append(" NOT IN ? ");
		strSql.append(" OR ").append(W83bCitacionesVistaBD.numImpugnacion).append(" NOT IN ? )");
	}
	strSql.append(" ORDER BY ").append(W83bCitacionesVistaBD.citacionesView).append(".").append(W83bCitacionesVistaBD.HORACITACIONI).append(" ASC");
		
	
	params.add(param.get("fecha"));
	params.add(param.get("cterritorio"));
	if(param.get("excluir")!=null && param.get("excluir").equals("true"))
	{
		params.add(param.get("anio"));
		params.add(W83bUtilidades.rellenarCaracter((String)param.get("num"),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true));
	}
	
	
	
	return   W83bDataBase.executeQuery(strSql.toString(),params,W83bCitacionBean.class,null, null);
	
	
	}
	
	public W83bSindicatosBean cargarDatosSindicatos(String codigo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bSindicatosBD.direccion).append(", ");
		strSql.append(W83bSindicatosBD.cp).append(", ");
		strSql.append(W83bSindicatosBD.municipio).append(", ");
		strSql.append(W83bSindicatosBD.provincia);		
		strSql.append(" FROM ").append(W83bSindicatosBD.sindicatosVista);		
		strSql.append(" WHERE ").append(W83bSindicatosBD.codSindicato).append(" = ?");		
		params.add(new Integer(codigo));			
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bSindicatosBean.class,null, null);
		W83bSindicatosBean sindicato=null;
		if(lista.size()>0)
		{	
			sindicato=(W83bSindicatosBean)lista.get(0);
		}
		return sindicato;

	}


}

